% Copyright (c) 2017 Joris Degroote
%
% Licensed under the Non-Profit Open Software License version 3.0
% (NPOSL-3.0). You should have received a copy of the NPOSL-3.0 along with 
% this file. If not, see <http://www.opensource.org/licenses/NPOSL-3.0>
%
% Animation of the result.
    
classdef Animator < handle
    properties (SetAccess=private)
        n;
        time;
        history;
        figure_animation;
        handle_animation;
        figure_history;
        handle_history;
    end
    properties (SetAccess=immutable)
        dt;
        delay;
        graphics;
    end
    methods
        function A=Animator(dt,x,z,time,delay,graphics)
            A.n=0;
            A.time=0;
            A.history=x(floor(end/2));
            
            if (graphics)
                scrsz=get(0,'ScreenSize');
                color='k';
                linewidth=2.0;
                min_value=0.0;
                max_value=0.001;
            
                A.figure_animation=figure('Position',...
                    [1 scrsz(4)/2 scrsz(3)/2 scrsz(4)/2]);
                A.handle_animation=plot(z,x,'Color',color,...
                    'LineWidth',linewidth);
                ylim([min_value max_value]);
                xlabel('z [m]');
                ylabel('r [m]');
            
                A.figure_history=figure('Position',...
                    [scrsz(3)/2 scrsz(4)/2 scrsz(3)/2 scrsz(4)/2]);
                A.handle_history=plot(A.time,A.history,'Color',color,...
                    'LineWidth',linewidth);
                xlim([0 time]);
                ylim([min_value max_value]);
                xlabel('t [s]');
                ylabel('r [m]');
            end
            
            A.dt=dt;
            A.delay=delay;
            A.graphics=graphics;
        end
        function delete(A)
            if (A.graphics)
                close(A.figure_animation);
                close(A.figure_history);
            end
        end
        function add(A,x,z)
            A.time=[A.time; A.n*A.dt];
            A.history=[A.history; x(floor(end/2))];
            if (A.graphics)
                set(A.handle_animation,'XData',z,'YData',x);
                set(A.handle_history,'XData',A.time,'YData',A.history);
                drawnow;
            end
        end
        function increase_time(A)
            A.n=A.n+1;
            if (A.graphics)
                pause(A.delay);
            end
        end
    end
end
