% Copyright (c) 2017 Joris Degroote
%
% Licensed under the Non-Profit Open Software License version 3.0
% (NPOSL-3.0). You should have received a copy of the NPOSL-3.0 along with 
% this file. If not, see <http://www.opensource.org/licenses/NPOSL-3.0>
%
% Critertion for the convergence of the coupling iterations.

classdef Convergence < handle
    properties (SetAccess=private)
        reso=0.0;
        resk=0.0;
        tol;
        k_min;
        k=0;
        n=0;
        small;
        output;
        hist=[];
    end
    methods
        function C=Convergence(tol,k_min,small,output)
            C.tol=tol;
            C.k_min=k_min;
            C.small=small;
            C.output=output;
        end
        function add(C,r)
            C.k=C.k+1;
            C.resk=norm(r);
            if (C.k==1)
                C.reso=C.resk;
            end
            if (C.output)
                if ((C.is_satisfied() && (C.output==1)) || (C.output==2))
                    disp([num2str(C.n) ' ' num2str(C.k) ' ' ...
                        num2str(C.resk)]);
                end
            end
        end
        function conv=is_satisfied(C)
            if ((C.resk<max(C.reso*C.tol,C.small)) && (C.k>C.k_min))
                conv=true;
            else
                conv=false;
            end
        end
        function increase_time(C)
            C.hist=[C.hist C.k];
            C.k=0;
            C.n=C.n+1;
        end
        function delete(C)
            disp('---');
            disp([num2str(C.n) ' ' num2str(mean(C.hist))]);
        end
    end
end
