% Copyright (c) 2011 Joris Degroote
%
% Licensed under the Non-Profit Open Software License version 3.0
% (NPOSL-3.0). You should have received a copy of the NPOSL-3.0 along with 
% this file. If not, see <http://www.opensource.org/licenses/NPOSL-3.0>
%
% Extrapolation of the data from previous time steps.    

classdef Extrapolator < handle
    properties (SetAccess=private)
        xp;
        x;
        xn;
        x2n;
        n=0;
        n0=0;
        n1=1;
        n2=2;
    end
    methods
        function E=Extrapolator(x)
            E.initialize(x);
        end
        function xe=predict(E)
            switch E.n
                case E.n0
                    error('Extrapolator cannot predict initial value');
                case E.n1
                    xe=E.x;
                case E.n2
                    xe=2.0*E.x-E.xn;
                otherwise
                    xe=2.5*E.x-2.0*E.xn+0.5*E.x2n;
            end
        end
        function add(E,x)
            E.xp=x;
        end
        function initialize(E,x)
            E.xp=x;
            E.x=x;
            E.xn=x;
            E.x2n=x;
        end
        function shift(E)
            E.x2n=E.xn;
            E.xn=E.x;
            E.x=E.xp;
        end
        function increase_time(E)
            E.n=E.n+1;
            E.shift();
        end
    end
end