% Copyright (c) 2011 Joris Degroote
%
% Licensed under the Non-Profit Open Software License version 3.0
% (NPOSL-3.0) available at http://www.opensource.org/licenses/NPOSL-3.0
%
% Matrix-free least-squares model.

classdef Model < handle
    properties (SetAccess=private)
        k;
        xr;
        yr;
        V;
        W;
        small;
    end
    methods
        function M=Model(small)
            M.reset();
            M.small=small;
        end
        function add(M,x,y)
            M.k=M.k+1;
            if (M.k>1)
                M.V=[x-M.xr M.V];
                M.W=[y-M.yr M.W];
            end
            M.xr=x;
            M.yr=y;
        end
        function dy=predict(M,dx)
            singular=true;
            while (singular && (M.k>1))
                [Q,R]=qr(M.V,0);
                [v,i]=min(abs(diag(R)));
                if (v<M.small)
                    M.V(:,i)=[];
                    M.W(:,i)=[];
                    M.k=M.k-1;
                else
                    singular=false;
                end
            end
            if (M.k<2)
                if (isempty(M.yr))
                    error('Model cannot predict without any data');
                else
                    dy=zeros(size(M.yr));
                end
            else  
                c=R\(Q'*dx);
                dy=M.W*c;
            end
        end
        function reset(M)
            M.k=0;
            M.xr=[];
            M.yr=[];
            M.V=[];
            M.W=[];
        end
        function increase_time(M)
            M.reset();
        end
    end
end