% Copyright (c) 2011 Joris Degroote
%
% Licensed under the Non-Profit Open Software License version 3.0
% (NPOSL-3.0). You should have received a copy of the NPOSL-3.0 along with 
% this file. If not, see <http://www.opensource.org/licenses/NPOSL-3.0>
%
% Calculation of the structural motion in a tube.

classdef Structure < handle
    properties (Constant)
        E_o=75000.0;
        r_o=0.005;
        h=0.003;
    end
    properties (SetAccess=immutable)
        dt;
        dz;
        m_e;
        m_so;
        m_sg;
        m_sh;
        m_fg;
        E;
        
        C_s;
        D_s;
        M_s;
        N_s;
    end
    properties (SetAccess=private)
        n;
        
        b_s;
        x_s;
        x_sn;
        x_fg;
        x_fgn;
    end
    methods
        function S=Structure(dt,dz,m_e)
            S.dt=dt;
            S.dz=dz;
            S.m_e=m_e;
            S.m_so=0;
            S.m_sg=S.m_e;
            S.m_sh=S.m_e;
            S.m_fg=S.m_e;
            S.E=S.E_o;
            
            S.C_s=-S.r_o^2/S.h*diag(1.0./S.E);
            S.D_s=zeros(S.m_sh,S.m_fg);
            S.M_s=eye(S.m_sg+S.m_so);
            S.N_s=zeros(S.m_sg+S.m_so);
            
            S.n=0;
            
            S.x_s=zeros(S.m_sg+S.m_so,1);
            S.x_sn=S.x_s;
            S.x_fg=zeros(S.m_fg,1);
            S.x_fgn=S.x_fg;            
        end
        function x_sg=calculate_primal(S,x_fg)
            S.x_fg=x_fg;
            S.x_s=S.M_s\(S.b_s+S.N_s*S.x_sn...
                +[S.D_s*S.x_fgn; zeros(S.m_sg+S.m_so-S.m_sh,1)]...
                -[S.C_s*S.x_fg; zeros(S.m_sg+S.m_so-S.m_sh,1)]);
            x_sg=S.x_s(1:S.m_sg,1);
        end
        function increase_time(S)
            S.n=S.n+1;
            
            S.b_s=zeros(S.m_sg+S.m_so,1);
            S.x_sn=S.x_s;
            S.x_fgn=S.x_fg;
        end
    end
end